<!DOCTYPE html>
<html lang="mr">
<head>
  <meta charset="UTF-8">
  <title>General Register</title>
  <style>
    @page {
      size: A3 landscape;
      margin: 10mm;
    }

    body {
      margin: 0;
      padding: 0;
      font-family: 'Noto Sans Devanagari', Arial, sans-serif;
      font-size: 11px;
      box-sizing: border-box;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      table-layout: fixed;
    }

    th, td {
      border: 1px solid black;
      padding: 2px;
      vertical-align: top;
      word-wrap: break-word;
      overflow-wrap: break-word;
    }

    th {
      font-weight: bold;
      text-align: center;
    }

    .multi-line {
      white-space: pre-line;
      text-align: left;
    }

    .header-title {
      text-align: center;
      font-weight: bold;
      font-size: 16px;
      padding: 4px 0;
    }

    .header-section {
      display: flex;
      justify-content: space-between;
      font-size: 12px;
      padding: 2px 5px;
    }

    .digit-table {
      border-collapse: collapse;
      margin: 2px 0;
      display: inline-block;
      page-break-inside: avoid;
    }

    .digit-table td {
      border: 1px solid black;
      width: 10px;
      height: 16px;
      padding: 0;
      box-sizing: border-box;
    }

    tr {
      page-break-inside: avoid;
    }

    .no-break {
      page-break-inside: avoid;
    }
  </style>

</head>
<body>

<div class="header-section">
  <div>शाळेचे नाव : <?php echo $setting_result[0]['name']; ?></div>

  <div>UDISE No:  <?php echo $setting_result[0]['sch_udise_high_secondary']; ?> &nbsp;&nbsp; पान क्रमांक _______</div>
</div>

<div class="header-title">GENERAL REGISTER | सर्वसाधारण नोंदवही</div>
<div style="text-align: right; padding: 0 5px;">शैक्षणिक वर्ष  <?php echo $currentSessionName; ?></div></div>

<table>
  <thead>
    <tr>
      <th rowspan="3">जनरल<br>रजिस्टर<br>नंबर</th>
      <th rowspan="3" class="multi-line" width="10%">विद्यार्थ्याचे संपूर्ण नाव<br>आईचे नाव<br>स्टुडंट आय.डी.<br>आधार कार्ड क्र. (यु.आय.डी.)</th>
      <th rowspan="3">राष्ट्रीयत्व<br>मातृभाषा</th>
      <th rowspan="3">धर्म<br>जात<br>पोटजात</th>
      <th rowspan="3">जन्मस्थळ</th>
      <th rowspan="3">जन्मदिनांक<br>(अंकी/अक्षरी)</th>
      <th rowspan="3" class="multi-line">यापूर्वीची शाळा व<br>इयत्ता<br>युडायस नं.</th>
      <th rowspan="3">प्रवेश<br>दिनांक</th>
      <th rowspan="3">कोणत्या<br>इयत्तेत<br>नाव दाखल केले</th>
      <th rowspan="3">अभ्यासातील<br>प्रगती</th>
      <th rowspan="3">वर्तणूक</th>
      <th rowspan="3">कोणत्या इयत्तेत<br>असताना शाळा सोडली</th>
      <th rowspan="3" class="multi-line">शाळा सोडल्याचे<br>कारण व दिनांक</th>
      <th rowspan="3" class="multi-line">दाखला मिळाल्याचा<br>दिनांक व पालकांची<br>स्वाक्षरी</th>
      <th rowspan="3">मुख्याध्यापक<br>स्वाक्षरी व शिक्का</th>
    </tr>
    <tr></tr><tr></tr>
  </thead>

  <tbody>
    <tr class="no-break">
      <td>1</td>
      <td class="multi-line">
        नांव :<?php echo $student->firstname
         ?><br>
        वडिलांचे नाव : <?php echo $student->middlename
        ?><br>
        आडनाव : <?php echo $student->lastname
        ?><br>
        आईचे नाव : <?php echo $student->mother_name
         ?><br><br>

         
        ID No:  <?php echo $student->std_global_id
         ?>
        <table class="digit-table" style="margin: 0;padding: 0;white-space: none;"><tr>
         
        </tr></table>

        UID No : <?php echo $student->adhar_no
         ?>
        

        Pan No :
      

        Apaar ID: <?php echo $student->apaar_id?>
        <table class="digit-table" style="margin: 0;padding: 0;white-space: none;"><tr>
          <!-- 12 boxes -->
          

        
        </tr></table>
      </td>
      <td class="multi-line">राष्ट्रीयत्व <?php echo $student->nationality?><br>मातृभाषा <?php echo $student->mother_tongue?></td>
      <td class="multi-line">धर्म <?php echo $student->religion?><br>जात <?php echo $student->cast?><br>पोटजात <?php echo $student->subcas?></td>
      <td class="multi-line">गांव <?php echo $student->birth_village?><br>तालुका <?php echo $student->birth_taluka?><br>जिल्हा <?php echo $student->birth_district?><br>राज्य <?php echo $student->state?></td>
      <td class="multi-line">अंकी <?php echo $student->dob?><br>अक्षरी <?php
        function numberToWords($number) {
            $words = array(
                '0' => 'zero', '1' => 'one', '2' => 'two', '3' => 'three', '4' => 'four',
                '5' => 'five', '6' => 'six', '7' => 'seven', '8' => 'eight', '9' => 'nine'
            );
            return implode(' ', array_map(function($digit) use ($words) {
                return $words[$digit] ?? $digit;
            }, str_split($number)));
        }

        function dateToWords($date) {
            $timestamp = strtotime($date);
            $day = date('d', $timestamp);
            $month = date('m', $timestamp);
            $year = date('Y', $timestamp);

            return numberToWords($day) . ' / ' . numberToWords($month) . ' / ' . numberToWords($year);
        }

        echo dateToWords($student->dob);
    ?></td>
      <td class="multi-line"><?php echo $student->previous_school?><br>इयत्ता : <?php echo $student->prev_school_standard_covered?><br>U-DISE-</td>
      <td><?php echo $student->admission_date?></td>
      <td class="multi-line">
    इयत्ता <?php echo $student->fillbyoffice_admittedto; ?><br>
    वर्ष <?php echo $student->admission_date; ?>
</td>
 
      <td><?php echo $student->academic_preference?></td>
      <td><?php echo $student->academic_conduct?></td>
       <td class="multi-line">
    इयत्ता <?php echo $student->fillbyoffice_admittedto; ?><br>
    वर्ष <?php echo $student->admission_date; ?>
</td>
      <td><?php echo $student->reason_of_leaving?>  <?php echo $student->date_of_leaving?></td>
      <td class="multi-line">T. C No. <?php echo $student->sn_cert_leaving?><br>दिनांक <?php echo $student->date_of_leaving?></td>
      <td>--------------------</td>
      

    </tr>
  </tbody>
</table>

</body>
</html>

<script>
  window.onload = function () {
    window.print();
  };
</script>